/**
 * \file: ipu_dp_csc.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * Compute and update IPU display processor color space (CSC) matrix w.r.t
 * change in color property like Hue, Saturation, Brightness, Contrast and
 * respective offset.
 *
 * \component: IPU
 *
 * \author: Gautham Kantharaju / RBEI / ECF3 / Gautham.Kantharaju@in.bosch.com
 *
 * \copyright: (c) 2015 ADIT Corporation
 *
 * \history
 * 0.1 Gautham Kantharaju Initial version
 ******************************************************************************/

#ifndef _IPU_DP_CSC_H_
#define _IPU_DP_CSC_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <error.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdint.h>
#include <math.h>
#include <imx_drm.h>
#include <xf86drm.h>
#include <xf86drmMode.h>

#define INVALID_VALUE				0xFF
#define MAX_SUPPORTED_CRTC_ID		2

typedef struct _clrprop
{
	int16_t hue;
	int16_t saturation;
	int16_t brightness;
	int16_t contrast;
	int16_t hue_off;
	int16_t saturation_off;
	int16_t brightness_off;
	struct drm_imx_csc csc;
	uint32_t supported_crtc_id[MAX_SUPPORTED_CRTC_ID];
}CLRPROP;

typedef enum csc_clr_space_type
{
	RGB2RGB = 0,
	RGB2YUV,
	YUV2RGB,
	YUV2YUV
}CLRSPACETYPE;

/* API's exported to application */

/* API to compute and update IPU DP CSC matrix */
int32_t csc_dp_compute_update_matrix (int32_t drm_fd, bool csc_update, CLRPROP *out);

/* API to update crtc id */
void csc_update_crtc_id (uint32_t crtc_id);

/* API to update color space conversion type */
void csc_update_color_space_conversion_type(CLRSPACETYPE type);

/* API to retrieve default color property value and CSC identity matrix */
void csc_set_default_value (CLRPROP *out);

#endif /* _IPU_DP_CSC_H_ */
